

;
;	FIG-FORTH 1.1 VERSION A0
;
FIGREL	EQU 1
FIGREV	EQU 1
USRVER	EQU 0
;
;	ASCII CHARACTERS USED
;
ABL	EQU 20H
BELL	EQU 07H
ACR	EQU 0DH
ADOT	EQU 02EH
BSIN	EQU 7FH
BSOUT	EQU 08H
DLE	EQU 10H
LF	EQU 0AH
FF	EQU 0CH
;
;	MEMORY ALLOCATION
;
HBASE	EQU 4200H
EM	EQU HBASE+3000H
NSCR	EQU 1
KBBUF	EQU 128
US	EQU 40H
RTS	EQU 0A0H
;
CO	EQU KBBUF+4
NBUF	EQU NSCR*400H/KBBUF
BUF1	EQU EM-CO*NBUF
INITR0	EQU BUF1-US
INITS0	EQU INITR0-RTS
;
	ORG HBASE+100H
ORIG	NOP
	JMP CLD
	NOP
	JMP WRM
	DB FIGREL
	DB FIGREV
	DB USRVER
	DB 0EH
	DW TASK-7
	DW BSIN
	DW INITR0
;<<<<<	FOLLOWING USED BY COLD;
;	MUST BE IN SAME ORDER AS USER VARIABLES
	DW INITS0
	DW INITR0
	DW INITS0
	DW 1FH
	DW 0
	DW INITDP
	DW INITDP
	DW FORTH+8
;<<<<<<<END	DATA USED BY COLD
	DW 5H,0B320H
;
;FORTH	REGISTERS
;
UP	DW INITR0
RPP	DW INITR0
;
;	DEBUG SUPPORT
;
BIP	DW 0
;
TNEXT	LXI H,BIP
	MOV A,M
	CMP C
	JNZ TNEXT1
	INX H
	MOV A,M
	CMP B
	JNZ TNEXT1
BREAK	NOP
	NOP
	NOP
TNEXT1	LDAX B
	INX B
	MOV L,A
	JMP NEXT+3
;
;	FORTH ADDRESS INTERPRETER
;
DPUSH	PUSH D
HPUSH	PUSH H
NEXT	LDAX B
	INX B
	MOV L,A
	LDAX B
	INX B
	MOV H,A
NEXT1:	MOV E,M
	INX H
	MOV D,M
	XCHG 
	PCHL
;
;	FORTH DICTIONARY
;
DP0	DB 83H
	DB 'LI'
	DB 'T'+80H
	DW 0
LIT	DW $+2
	LDAX B
	INX B
	MOV L,A
	LDAX B
	INX B
	MOV H,A
	JMP HPUSH
;
	DB 87H
	DB 'EXECUT'
	DB 'E'+80H
	DW LIT-6
EXEC	DW $+2
	POP H
	JMP NEXT1
;
	DB 86H
	DB 'BRANC'
	DB 'H'+80H
	DW EXEC-0AH
BRAN	DW $+2
BRAN1	MOV H,B
	MOV L,C
	MOV E,M
	INX H
	MOV D,M
	DCX H
	DAD D
	MOV C,L
	MOV B,H
	JMP NEXT
;
	DB 87H
	DB '0BRANC'
	DB 'H'+80H
	DW BRAN-9
ZBRAN	DW $+2
	POP H
	MOV A,L
	ORA H
	JZ BRAN1
	INX B
	INX B
	JMP NEXT
;
	DB 86H
	DB '(LOOP'
	DB ')'+80H
	DW ZBRAN-0AH
XLOOP	DW $+2
	LXI D,1
XLOO1	LHLD RPP
	MOV A,M
	ADD E
	MOV M,A
	MOV E,A
	INX H
	MOV A,M
	ADC D
	MOV M,A
	INX H
	INR D
	DCR D
	MOV D,A
	JM XLOO2
	MOV A,E
	SUB M
	MOV A,D
	INX H
	SBB M
	JMP XLOO3
XLOO2	MOV A,M
	SUB E
	INX H
	MOV A,M
	SBB D
;
XLOO3	JM BRAN1
	INX H
	SHLD RPP
	INX B
	INX B
	JMP NEXT
;
	DB 87H
	DB '(+LOOP'
	DB ')'+80H
	DW XLOOP-9
XPLOO	DW $+2
	POP D
	JMP XLOO1
;
	DB 84H
	DB '(DO'
	DB ')'+80H
	DW XPLOO-0AH
XDO	DW $+2
	LHLD RPP 
	DCX H
	DCX H
	DCX H
	DCX H
	SHLD RPP
	POP D
	MOV M,E
	INX H
	MOV M,D
	POP D
	INX H
	MOV M,E
	INX H
	MOV M,D
	JMP NEXT
;
	DB 81H
	DB 'I'+80H
	DW XDO-7
IDO	DW $+2
	LHLD RPP 
	MOV E,M
	INX H
	MOV D,M
	PUSH D
	JMP NEXT
;
	DB 85H
	DB 'DIGI'
	DB 'T'+80H
	DW IDO-4
DIGIT	DW $+2
	POP H
	POP D
	MOV A,E
	SUI 30H
	JM DIGI2
	CPI 0AH
	JM DIGI1
	SUI 7
	CPI 0AH
	JM DIGI2
;
DIGI1	CMP L
	JP DIGI2
	MOV E,A
	LXI H,1
	JMP DPUSH
;
DIGI2	MOV L,H
	JMP HPUSH
;
	DB 86H
	DB '(FIND'
	DB ')'+80H
	DW DIGIT-8
PFIND	DW $+2
	POP D
PFIN1	POP H
	PUSH H
	LDAX D
	XRA M
	ANI 3FH
	JNZ PFIN4
;
PFIN2	INX H
	INX D
	LDAX D
	XRA M
	ADD A
	JNZ PFIN3
	JNC PFIN2
	LXI H,5
	DAD D
	XTHL
;
PFIN6	DCX D
	LDAX D
	ORA A
	JP PFIN6
	MOV E,A
	MVI D,0
	LXI H,1
	JMP DPUSH
;
PFIN3	JC PFIN5
PFIN4	INX D
	LDAX D
	ORA A
	JP PFIN4
PFIN5	INX D
	XCHG
	MOV E,M
	INX H
	MOV D,M
	MOV A,D
	ORA E
	JNZ PFIN1
	POP H
	LXI H,0
	JMP HPUSH
;
	DB 87H
	DB 'ENCLOS'
	DB 'E'+80H
	DW PFIND-9
ENCL	DW $+2
	POP D
	POP H
	PUSH H
	MOV A,E
	MOV D,A
	MVI E,0FFH
	DCX H
;
ENCL1	INX H
	INR E
	CMP M
	JZ ENCL1
;
	MVI D,0
	PUSH D
	MOV D,A
	MOV A,M
	ANA A
	JNZ ENCL2
	MVI D,0
	INR E
	PUSH D
	DCR E
	PUSH D
	JMP NEXT
;
ENCL2	MOV A,D
	INX H
	INR E
	CMP M
	JZ ENCL4
	MOV A,M
	ANA A
	JNZ ENCL2
;
ENCL3	MVI D,0
	PUSH D
	PUSH D
	JMP NEXT
;
ENCL4	MVI D,0
	PUSH D
	INR E
	PUSH D
	JMP NEXT
;
	DB 84H
	DB 'EMI'
	DB 'T'+80H
	DW ENCL-0AH
EMIT	DW DOCOL
	DW PEMIT
	DW ONE,OUTT
	DW PSTOR,SEMIS
;
	DB 83H
	DB 'KE'
	DB 'Y'+80H
	DW EMIT-7
KEY	DW $+2
	JMP PKEY
;
	DB 89H
	DB '?TERMINA'
	DB 'L'+80H
	DW KEY-6
QTERM	DW $+2
	LXI H,0
	JMP PQTER
;
	DB 82H
	DB 'C'
	DB 'R'+80H
	DW QTERM-0CH
CR	DW $+2
	JMP PCR
;
	DB 85H
	DB 'CMOV'
	DB 'E'+80H
	DW CR-5
CMOVE	DW $+2
	MOV L,C
	MOV H,B
	POP B
	POP D
	XTHL
;
	JMP CMOV2
CMOV1	MOV A,M
	INX H
	STAX D
	INX D
	DCX B
CMOV2	MOV A,B
	ORA C
	JNZ CMOV1
	POP B
	JMP NEXT
;
	DB 82H
	DB 'U'
	DB '*'+80H
	DW CMOVE-8
USTAR	DW $+2
	POP D
	POP H
	PUSH B
	MOV B,H
	MOV A,L
	CALL MPYX
	PUSH H
	MOV H,A
	MOV A,B
	MOV B,H
	CALL MPYX
	POP D
	MOV C,D
	DAD B
	ACI 0
	MOV D,L
	MOV L,H
	MOV H,A
	POP B
	PUSH D
	JMP HPUSH
;
;	MULTIPLY PRIMITIVE
;
MPYX	LXI H,0
	MVI C,8
MPYX1	DAD H
	RAL 
	JNC MPYX2
	DAD D
	ACI 0
MPYX2	DCR C
	JNZ MPYX1
	RET
;
	DB 82H
	DB 'U'
	DB '/'+80H
	DW USTAR-5
USLAS	DW $+2
	LXI H,4
	DAD SP
	MOV E,M
	MOV M,C
	INX H
	MOV D,M
	MOV M,B
	POP B
	POP H
	MOV A,L
	SUB C
	MOV A,H
	SBB B
	JC USLA1
	LXI H,0FFFFH
	LXI D,0FFFFH
	JMP USLA7
USLA1	MVI A,16
USLA2	DAD H
	RAL 
	XCHG
	DAD H
	JNC USLA3
	INX D
	ANA A
USLA3	XCHG
	RAR
	PUSH PSW
	JNC USLA4
	MOV A,L
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	JMP USLA5
USLA4	MOV A,L
	SUB C
	MOV L,A
	MOV A,H
	SBB B
	MOV H,A
	JNC USLA5
	DAD B
	DCX D
USLA5	INX D
USLA6	POP PSW
	DCR A
	JNZ USLA2
USLA7	POP B
	PUSH H
	PUSH D
	JMP NEXT
;
	DB 83H
	DB 'AN'
	DB 'D'+80H
	DW USLAS-5
ANDD	DW $+2
	POP D
	POP H
	MOV A,E
	ANA L
	MOV L,A
	MOV A,D
	ANA H
	MOV H,A
	JMP HPUSH
;
	DB 82H
	DB 'O'
	DB 'R'+80H
	DW ANDD-6
ORR	DW $+2
	POP D
	POP H
	MOV A,E
	ORA L
	MOV L,A
	MOV A,D
	ORA H
	MOV H,A
	JMP HPUSH
;
	DB 83H
	DB 'XO'
	DB 'R'+80H
	DW ORR-5
XORR	DW $+2
	POP D
	POP H
	MOV A,E
	XRA L
	MOV L,A
	MOV A,D
	XRA H
	MOV H,A
	JMP HPUSH
;
	DB 83H
	DB 'SP'
	DB '@'+80H
	DW XORR-6
SPAT	DW $+2
	LXI H,0
	DAD SP
	JMP HPUSH
;
	DB 83H
	DB 'SP'
	DB '!'+80H
	DW SPAT-6
SPSTO	DW $+2
	LHLD UP
	LXI D,6
	DAD D
	MOV E,M
	INX H
	MOV D,M
	XCHG
	SPHL
	JMP NEXT
;
	DB 83H
	DB 'RP'
	DB '@'+80H
	DW SPSTO-6
RPAT	DW $+2
	LHLD RPP
	JMP HPUSH
;
	DB 83H
	DB 'RP'
	DB '!'+80H
	DW RPAT-6
RPSTO	DW $+2
	LHLD UP
	LXI D,8
	DAD D
	MOV E,M
	INX H
	MOV D,M
	XCHG
	SHLD RPP
	JMP NEXT
;
	DB 82H
	DB ';'
	DB 'S'+80H
	DW RPSTO-6
SEMIS	DW $+2
	LHLD RPP
	MOV C,M
	INX H
	MOV B,M
	INX H
	SHLD RPP
	JMP NEXT
;
	DB 85H
	DB 'LEAV'
	DB 'E'+80H
	DW SEMIS-5
LEAVE	DW $+2
	LHLD RPP 
	MOV E,M
	INX H
	MOV D,M
	INX H
	MOV M,E
	INX H
	MOV M,D
	JMP NEXT
;
	DB 82H
	DB '>'
	DB 'R'+80H
	DW LEAVE-8
TOR	DW $+2
	POP D
	LHLD RPP
	DCX H
	DCX H
	SHLD RPP
	MOV M,E
	INX H
	MOV M,D
	JMP NEXT
;
	DB 82H
	DB 'R'
	DB '>'+80H
	DW TOR-5
FROMR	DW $+2
	LHLD RPP 
	MOV E,M
	INX H
	MOV D,M
	INX H
	SHLD RPP
	PUSH D
	JMP NEXT
;
	DB 81H
	DB 'R'+80H
	DW FROMR-5
RR	DW IDO+2
;
	DB 82H
	DB '0'
	DB '='+80H
	DW RR-4
ZEQU	DW $+2
	POP H
	MOV A,L
	ORA H
	LXI H,0
	JNZ ZEQU1
	INX H
ZEQU1	JMP HPUSH
;
	DB 82H
	DB '0'
	DB '<'+80H
	DW ZEQU-5
ZLESS	DW $+2
	POP H
	DAD H
	LXI H,0
	JNC ZLES1
	INX H
ZLES1	JMP HPUSH
;
	DB 81H
	DB '+'+80H
	DW ZLESS-5
PLUS	DW $+2
	POP D
	POP H
	DAD D
	JMP HPUSH
;
	DB 82H
	DB 'D'
	DB '+'+80H
	DW PLUS-4
DPLUS	DW $+2
	LXI H,6
	DAD SP
	MOV E,M
	MOV M,C
	INX H
	MOV D,M
	MOV M,B
	POP B
	POP H
	DAD D
	XCHG
	POP H
	MOV A,L
	ADC C
	MOV L,A
	MOV A,H
	ADC B
	MOV H,A
	POP B
	PUSH D
	JMP HPUSH
;
	DB 85H
	DB 'MINU'
	DB 'S'+80H
	DW DPLUS-5
MINUS	DW $+2
	POP H
	MOV A,L
	CMA
	MOV L,A
	MOV A,H
	CMA
	MOV H,A
	INX H
	JMP HPUSH
;
	DB 86H
	DB 'DMINU'
	DB 'S'+80H
	DW MINUS-8
DMINU	DW $+2
	POP H
	POP D
	SUB A
	SUB E
	MOV E,A
	MVI A,0
	SBB D
	MOV D,A
	MVI A,0
	SBB L
	MOV L,A
	MVI A,0
	SBB H
	MOV H,A
	PUSH D
	JMP HPUSH
;
	DB 84H
	DB 'OVE'
	DB 'R'+80H
	DW DMINU-9
OVER	DW $+2
	POP D
	POP H
	PUSH H
	JMP DPUSH
;
	DB 84H
	DB 'DRO'
	DB 'P'+80H
	DW OVER-7
DROP	DW $+2
	POP H
	JMP NEXT
;
	DB 84H
	DB 'SWA'
	DB 'P'+80H
	DW DROP-7
SWAP	DW $+2
	POP H
	XTHL
	JMP HPUSH
;
	DB 83H
	DB 'DU'
	DB 'P'+80H
	DW SWAP-7
DUP	DW $+2
	POP H
	PUSH H
	JMP HPUSH
;
	DB 84H
	DB '2DU'
	DB 'P'+80H
	DW DUP-6
TDUP	DW $+2
	POP H
	POP D
	PUSH D
	PUSH H
	JMP DPUSH
;
	DB 82H
	DB '+'
	DB '!'+80H
	DW TDUP-7
PSTOR	DW $+2
	POP H
	POP D
	MOV A,M
	ADD E
	MOV M,A
	INX H
	MOV A,M
	ADC D
	MOV M,A
	JMP NEXT
;
	DB 86H
	DB 'TOGGL'
	DB 'E'+80H
	DW PSTOR-5
TOGGL	DW $+2
	POP D
	POP H
	MOV A,M
	XRA E
	MOV M,A
	JMP NEXT
;
	DB 81H
	DB '@'+80H
	DW TOGGL-9
AT	DW $+2
	POP H
	MOV E,M
	INX H
	MOV D,M
	PUSH D
	JMP NEXT
;
	DB 82H
	DB 'C'
	DB '@'+80H
	DW AT-4
CAT	DW $+2
	POP H
	MOV L,M
	MVI H,0
	JMP HPUSH
;
	DB 82H
	DB '2'
	DB '@'+80H
	DW CAT-5
TAT	DW $+2
	POP H
	LXI D,2
	DAD D
	MOV E,M
	INX H
	MOV D,M
	PUSH D
	LXI D,-3
	DAD D
	MOV E,M
	INX H
	MOV D,M
	PUSH D
	JMP NEXT
;
	DB 81H
	DB '!'+80H
	DW TAT-5
STORE	DW $+2
	POP H
	POP D
	MOV M,E
	INX H
	MOV M,D
	JMP NEXT
;
	DB 82H
	DB 'C'
	DB '!'+80H
	DW STORE-4
CSTOR	DW $+2
	POP H
	POP D
	MOV M,E
	JMP NEXT
;
	DB 82H
	DB '2'
	DB '!'+80H
	DW CSTOR-5
TSTOR	DW $+2
	POP H
	POP D
	MOV M,E
	INX H
	MOV M,D
	INX H
	POP D
	MOV M,E
	INX H
	MOV M,D
	JMP NEXT
;
	DB 0C1H ; :
	DB ':'+80H
	DW TSTOR-5
COLON	DW DOCOL
	DW QEXEC
	DW SCSP
	DW CURR
	DW AT
	DW CONT
	DW STORE
	DW CREAT
	DW RBRAC
	DW PSCOD
DOCOL	LHLD RPP
	DCX H
	MOV M,B
	DCX H
	MOV M,C
	SHLD RPP
	INX D
	MOV C,E
	MOV B,D
	JMP NEXT
;
	DB 0C1H ; ;
	DB ';'+80H
	DW COLON-4
SEMI	DW DOCOL
	DW QCSP
	DW COMP
	DW SEMIS
	DW SMUDG
	DW LBRAC
	DW SEMIS
;
	DB 84H
	DB 'NOO'
	DB 'P'+80H
	DW SEMI-4
NOOP	DW DOCOL
	DW SEMIS
;
	DB 88H
	DB 'CONSTAN'
	DB 'T'+80H
	DW NOOP-7
CON	DW DOCOL
	DW CREAT
	DW SMUDG
	DW COMMA 
	DW PSCOD
DOCON	INX D
	XCHG
	MOV E,M
	INX H
	MOV D,M
	PUSH D
	JMP NEXT
;
	DB 88H
	DB 'VARIABL'
	DB 'E'+80H
	DW CON-0BH
VAR	DW DOCOL
	DW CON
	DW PSCOD
DOVAR	INX D
	PUSH D
	JMP NEXT
;
	DB 84H
	DB 'USE'
	DB 'R'+80H
	DW VAR-0BH
USER	DW DOCOL
	DW CON
	DW PSCOD
DOUSE	INX D
	XCHG
	MOV E,M
	MVI D,0
	LHLD UP
	DAD D
	JMP HPUSH
;
	DB 81H
	DB '0'+80H
	DW USER-7
ZERO	DW DOCON
	DW 0
;
	DB 81H
	DB '1'+80H
	DW ZERO-4
ONE	DW DOCON
	DW 1
;
	DB 81H
	DB '2'+80H
	DW ONE-4
TWO	DW DOCON
	DW 2
;
	DB 81H
	DB '3'+80H
	DW TWO-4
THREE	DW DOCON
	DW 3
;
	DB 82H
	DB 'B'
	DB 'L'+80H
	DW THREE-4
BL	DW DOCON
	DW 20H
;
	DB 83H
	DB 'C/'
	DB 'L'+80H
	DW BL-5
CSLL	DW DOCON
	DW 64
;
	DB 85H
	DB 'FIRS'
	DB 'T'+80H
	DW CSLL-6
FIRST	DW DOCON
	DW BUF1
;
	DB 85H
	DB 'LIMI'
	DB 'T'+80H
	DW FIRST-8
LIMIT	DW DOCON
	DW EM
;
	DB 85H
	DB 'B/BU'
	DB 'F'+80H
	DW LIMIT-8
BBUF	DW DOCON
	DW KBBUF
;
	DB 85H
	DB 'B/SC'
	DB 'R'+80H
	DW BBUF-8
BSCR	DW DOCON
	DW 400H/KBBUF
;
	DB 87H
	DB '+ORIGI'
	DB 'N'+80H
	DW BSCR-8
PORIG	DW DOCOL
	DW LIT
	DW ORIG
	DW PLUS
	DW SEMIS
;
;	USER VARIABLES
;
	DB 82H
	DB 'S'
	DB '0'+80H
	DW PORIG-0AH
SZERO	DW DOUSE
	DW 6
;
	DB 82H
	DB 'R'
	DB '0'+80H
	DW SZERO-5
RZERO	DW DOUSE
	DW 8
;
	DB 83H
	DB 'TI'
	DB 'B'+80H
	DW RZERO-5
TIB	DW DOUSE
	DB 0AH
;
	DB 85H
	DB 'WIDT'
	DB 'H'+80H
	DW TIB-6
WIDTH	DW DOUSE
	DB 0CH
;
	DB 87H
	DB 'WARNIN'
	DB 'G'+80H
	DW WIDTH-8
WARN	DW DOUSE
	DB 0EH
;
	DB 85H
	DB 'FENC'
	DB 'E'+80H
	DW WARN-0AH
FENCE	DW DOUSE
	DB 10H
;
	DB 82H
	DB 'D'
	DB 'P'+80H
	DW FENCE-8
DP	DW DOUSE
	DB 12H
;
	DB 88H
	DB 'VOC-LIN'
	DB 'K'+80H
	DW DP-5
VOCL	DW DOUSE
	DW 14H
;
	DB 83H
	DB 'BL'
	DB 'K'+80H
	DW VOCL-0BH
BLK	DW DOUSE
	DB 16H
;
	DB 82H
	DB 'I'
	DB 'N'+80H
	DW BLK-6
INN	DW DOUSE
	DB 18H
;
	DB 83H
	DB 'OU'
	DB 'T'+80H
	DW INN-5
OUTT	DW DOUSE
	DB 1AH
;
	DB 83H
	DB 'SC'
	DB 'R'+80H
	DW OUTT-6
SCR	DW DOUSE
	DB 1CH
;
	DB 86H
	DB 'OFFSE'
	DB 'T'+80H
	DW SCR-6
OFSET	DW DOUSE
	DB 1EH
;
	DB 87H
	DB 'CONTEX'
	DB 'T'+80H
	DW OFSET-9
CONT	DW DOUSE
	DB 20H
;
	DB 87H
	DB 'CURREN'
	DB 'T'+80H
	DW CONT-0AH
CURR	DW DOUSE
	DB 22H
;
	DB 85H
	DB 'STAT'
	DB 'E'+80H
	DW CURR-0AH
STATE	DW DOUSE
	DB 24H
;
	DB 84H
	DB 'BAS'
	DB 'E'+80H
	DW STATE-8
BASE	DW DOUSE
	DB 26H
;
	DB 83H
	DB 'DP'
	DB 'L'+80H
	DW BASE-7
DPL	DW DOUSE
	DB 28H
;
	DB 83H
	DB 'FL'
	DB 'D'+80H
	DW DPL-6
FLD	DW DOUSE
	DB 2AH
;
	DB 83H
	DB 'CS'
	DB 'P'+80H
	DW FLD-6
CSPP	DW DOUSE
	DB 2CH
;
	DB 82H
	DB 'R'
	DB '#'+80H
	DW CSPP-6
RNUM	DW DOUSE
	DB 2EH
;
	DB 83H
	DB 'HL'
	DB 'D'+80H
	DW RNUM-5
HLD	DW DOUSE
	DW 30H
;
;	END OF USER VARIABLES
;
	DB 82H
	DB '1'
	DB '+'+80H
	DW HLD-6
ONEP	DW DOCOL
	DW ONE
	DW PLUS
	DW SEMIS
;
	DB 82H
	DB '2'
	DB '+'+80H
	DW ONEP-5
TWOP	DW DOCOL
	DW TWO
	DW PLUS
	DW SEMIS
;
	DB 84H
	DB 'HER'
	DB 'E'+80H
	DW TWOP-5
HERE	DW DOCOL
	DW DP
	DW AT
	DW SEMIS
;
	DB 85H
	DB 'ALLO'
	DB 'T'+80H
	DW HERE-7
ALLOT	DW DOCOL
	DW DP
	DW PSTOR
	DW SEMIS
;
	DB 81H
	DB ','+80H
	DW ALLOT-8
COMMA	DW DOCOL
	DW HERE
	DW STORE
	DW TWO
	DW ALLOT
	DW SEMIS
;
	DB 82H
	DB 'C'
	DB ','+80H
	DW COMMA-4
CCOMM	DW DOCOL
	DW HERE
	DW CSTOR
	DW ONE
	DW ALLOT
	DW SEMIS
;
;	SUBROUTINE USED BY - AND <
;
SSUB	MOV A,L
	SUB E
	MOV L,A
	MOV A,H
	SBB D
	MOV H,A
	RET
;
	DB 81H
	DB '-'+80H
	DW CCOMM-5
SUBB	DW $+2
	POP D
	POP H
	CALL SSUB
	JMP HPUSH
;
	DB 81H
	DB '='+80H
	DW SUBB-4
EQUAL	DW DOCOL
	DW SUBB
	DW ZEQU
	DW SEMIS
;
	DB 81H
	DB '<'+80H
	DW EQUAL-4
LESS	DW $+2
	POP D
	POP H
	MOV A,D
	XRA H
	JM LES1
	CALL SSUB
LES1	INR H
	DCR H
	JM LES2
	LXI H,0
	JMP HPUSH
LES2	LXI H,1
	JMP HPUSH
;
	DB 82H
	DB 'U'
	DB '<'+80H
	DW LESS-4
ULESS	DW DOCOL,TDUP
	DW XORR,ZLESS
	DW ZBRAN,ULES1-$
	DW DROP,ZLESS
	DW ZEQU
	DW BRAN,ULES2-$
ULES1	DW SUBB,ZLESS
ULES2	DW SEMIS
;
	DB 81H
	DB '>'+80H
	DW ULESS-5
GREAT	DW DOCOL
	DW SWAP
	DW LESS
	DW SEMIS
;
	DB 83H
	DB 'RO'
	DB 'T'+80H
	DW GREAT-4
ROT	DW $+2
	POP D
	POP H
	XTHL
	JMP DPUSH
;
	DB 85H
	DB 'SPAC'
	DB 'E'+80H
	DW ROT-6
SPACE	DW DOCOL
	DW BL
	DW EMIT
	DW SEMIS
;
	DB 84H
	DB '-DU'
	DB 'P'+80H
	DW SPACE-8
DDUP	DW DOCOL
	DW DUP
	DW ZBRAN
	DW DDUP1-$
	DW DUP
DDUP1	DW SEMIS
;
	DB 88H
	DB 'TRAVERS'
	DB 'E'+80H
	DW DDUP-7
TRAV	DW DOCOL
	DW SWAP
TRAV1	DW OVER
	DW PLUS
	DW LIT
	DW 7FH
	DW OVER
	DW CAT
	DW LESS
	DW ZBRAN
	DW TRAV1-$
	DW SWAP
	DW DROP
	DW SEMIS
;
	DB 86H
	DB 'LATES'
	DB 'T'+80H
	DW TRAV-0BH
LATES	DW DOCOL
	DW CURR
	DW AT
	DW AT
	DW SEMIS
;
	DB 83H
	DB 'LF'
	DB 'A'+80H
	DW LATES-9
LFA	DW DOCOL
	DW LIT
	DW 4
	DW SUBB
	DW SEMIS
;
	DB 83H
	DB 'CF'
	DB 'A'+80H
	DW LFA-6
CFA	DW DOCOL
	DW TWO
	DW SUBB
	DW SEMIS
;
	DB 83H
	DB 'NF'
	DB 'A'+80H
	DW CFA-6
NFA	DW DOCOL
	DW LIT
	DW 5
	DW SUBB
	DW LIT
	DW -1
	DW TRAV
	DW SEMIS
;
	DB 83H
	DB 'PF'
	DB 'A'+80H
	DW NFA-6
PFA	DW DOCOL
	DW ONE
	DW TRAV
	DW LIT
	DW 5
	DW PLUS
	DW SEMIS
;
	DB 84H
	DB '!CS'
	DB 'P'+80H
	DW PFA-6
SCSP	DW DOCOL
	DW SPAT
	DW CSPP
	DW STORE
	DW SEMIS
;
	DB 86H
	DB '?ERRO'
	DB 'R'+80H
	DW SCSP-7
QERR	DW DOCOL
	DW SWAP
	DW ZBRAN
	DW QERR1-$
	DW ERROR
	DW BRAN
	DW QERR2-$
QERR1	DW DROP
QERR2	DW SEMIS
;
	DB 85H
	DB '?COM'
	DB 'P'+80H
	DW QERR-9
QCOMP	DW DOCOL
	DW STATE
	DW AT
	DW ZEQU
	DW LIT
	DW 11H
	DW QERR
	DW SEMIS
;
	DB 85H
	DB '?EXE'
	DB 'C'+80H
	DW QCOMP-8
QEXEC	DW DOCOL
	DW STATE
	DW AT
	DW LIT
	DW 12H
	DW QERR
	DW SEMIS
;
	DB 86H
	DB '?PAIR'
	DB 'S'+80H
	DW QEXEC-8
QPAIR	DW DOCOL
	DW SUBB
	DW LIT
	DW 13H
	DW QERR
	DW SEMIS
;
	DB 84H
	DB '?CS'
	DB 'P'+80H
	DW QPAIR-9
QCSP	DW DOCOL
	DW SPAT
	DW CSPP
	DW AT
	DW SUBB
	DW LIT
	DW 14H
	DW QERR
	DW SEMIS
;
	DB 88H
	DB '?LOADIN'
	DB 'G'+80H
	DW QCSP-7
QLOAD	DW DOCOL
	DW BLK
	DW AT
	DW ZEQU
	DW LIT
	DW 16H
	DW QERR
	DW SEMIS
;
	DB 87H
	DB 'COMPIL'
	DB 'E'+80H
	DW QLOAD-0BH
COMP	DW DOCOL
	DW QCOMP
	DW FROMR
	DW DUP
	DW TWOP
	DW TOR
	DW AT
	DW COMMA
	DW SEMIS
;
	DB 0C1H
	DB '['+80H
	DW COMP-0AH
LBRAC	DW DOCOL
	DW ZERO
	DW STATE
	DW STORE
	DW SEMIS
;
	DB 81H
	DB ']'+80H
	DW LBRAC-4
RBRAC	DW DOCOL
	DW LIT,0C0H
	DW STATE,STORE
	DW SEMIS
;
	DB 86H
	DB 'SMUDG'
	DB 'E'+80H
	DW RBRAC-4
SMUDG	DW DOCOL
	DW LATES
	DW LIT
	DW 20H
	DW TOGGL
	DW SEMIS
;
	DB 83H
	DB 'HE'
	DB 'X'+80H
	DW SMUDG-9
HEX	DW DOCOL
	DW LIT
	DW 10H
	DW BASE
	DW STORE
	DW SEMIS
;
	DB 87H
	DB 'DECIMA'
	DB 'L'+80H
	DW HEX-6
DEC	DW DOCOL
	DW LIT
	DW 0AH
	DW BASE
	DW STORE
	DW SEMIS
;
	DB 87H
	DB '(;CODE'
	DB ')'+80H
	DW DEC-0AH
PSCOD	DW DOCOL
	DW FROMR
	DW LATES
	DW PFA
	DW CFA
	DW STORE
	DW SEMIS
;
	DB 0C5H
	DB ';COD'
	DB 'E'+80H
	DW PSCOD-0AH
SEMIC	DW DOCOL
	DW QCSP
	DW COMP
	DW PSCOD
	DW LBRAC
SEMI1	DW NOOP
	DW SEMIS
;
	DB 87H
	DB '<BUILD'
	DB 'S'+80H
	DW SEMIC-8
BUILD	DW DOCOL
	DW ZERO
	DW CON
	DW SEMIS
;
	DB 85H
	DB 'DOES'
	DB '>'+80H
	DW BUILD-0AH
DOES	DW DOCOL
	DW FROMR
	DW LATES
	DW PFA
	DW STORE
	DW PSCOD
DODOE	LHLD RPP
	DCX H
	MOV M,B
	DCX H
	MOV M,C
	SHLD RPP
	INX D
	XCHG
	MOV C,M
	INX H
	MOV B,M
	INX H
	JMP HPUSH
;
	DB 85H
	DB 'COUN'
	DB 'T'+80H
	DW DOES-8
COUNT	DW DOCOL
	DW DUP
	DW ONEP
	DW SWAP
	DW CAT
	DW SEMIS
;
	DB 84H
	DB 'TYP'
	DB 'E'+80H
	DW COUNT-8
TYPE	DW DOCOL
	DW DDUP
	DW ZBRAN
	DW TYPE1-$
	DW OVER
	DW PLUS
	DW SWAP
	DW XDO
TYPE2	DW IDO
	DW CAT
	DW EMIT
	DW XLOOP
	DW TYPE2-$
	DW BRAN
	DW TYPE3-$
TYPE1	DW DROP
TYPE3	DW SEMIS
;
	DB 89H
	DB '-TRAILIN'
	DB 'G'+80H
	DW TYPE-7
DTRAI	DW DOCOL
	DW DUP
	DW ZERO
	DW XDO
DTRA1	DW OVER
	DW OVER
	DW PLUS
	DW ONE
	DW SUBB
	DW CAT
	DW BL
	DW SUBB
	DW ZBRAN
	DW DTRA2-$
	DW LEAVE
	DW BRAN
	DW DTRA3-$
DTRA2	DW ONE
	DW SUBB
DTRA3	DW XLOOP
	DW DTRA1-$
	DW SEMIS
;
	DB 84H
	DB '(."'
	DB ')'+80H
	DW DTRAI-0CH
PDOTQ	DW DOCOL
	DW RR
	DW COUNT
	DW DUP
	DW ONEP
	DW FROMR
	DW PLUS
	DW TOR
	DW TYPE
	DW SEMIS
;
	DB 0C2H
	DB '.'
	DB '"'+80H
	DW PDOTQ-7
DOTQ	DW DOCOL
	DW LIT
	DW 22H
	DW STATE
	DW AT
	DW ZBRAN
	DW DOTQ1-$
	DW COMP
	DW PDOTQ
	DW WORD
	DW HERE
	DW CAT
	DW ONEP
	DW ALLOT
	DW BRAN
	DW DOTQ2-$
DOTQ1	DW WORD
	DW HERE
	DW COUNT
	DW TYPE
DOTQ2	DW SEMIS
;
	DB 86H
	DB 'EXPEC'
	DB 'T'+80H
	DW DOTQ-5
EXPEC	DW DOCOL
	DW OVER
	DW PLUS
	DW OVER
	DW XDO
EXPE1	DW KEY
	DW DUP
	DW LIT
	DW 0EH
	DW PORIG
	DW AT
	DW EQUAL
	DW ZBRAN
	DW EXPE2-$
	DW DROP
	DW DUP
	DW IDO
	DW EQUAL
	DW DUP
	DW FROMR
	DW TWO
	DW SUBB
	DW PLUS
	DW TOR
	DW ZBRAN
	DW EXPE6-$
	DW LIT
	DW BELL
	DW BRAN
	DW EXPE7-$
EXPE6	DW LIT
	DW BSOUT
EXPE7	DW BRAN
	DW EXPE3-$
EXPE2	DW DUP
	DW LIT
	DW 0DH
	DW EQUAL
	DW ZBRAN
	DW EXPE4-$
	DW LEAVE
	DW DROP
	DW BL
	DW ZERO
	DW BRAN
	DW EXPE5-$
EXPE4	DW DUP
EXPE5	DW IDO
	DW CSTOR
	DW ZERO
	DW IDO
	DW ONEP
	DW STORE
EXPE3	DW EMIT
	DW XLOOP
	DW EXPE1-$
	DW DROP
	DW SEMIS
;
	DB 85H
	DB 'QUER'
	DB 'Y'+80H
	DW EXPEC-9
QUERY	DW DOCOL
	DW TIB
	DW AT
	DW LIT
	DW 50H
	DW EXPEC
	DW ZERO
	DW INN
	DW STORE
	DW SEMIS
;
	DB 0C1H
	DB 80H
	DW QUERY-8
NULL	DW DOCOL
	DW BLK
	DW AT
	DW ZBRAN
	DW NULL1-$
	DW ONE
	DW BLK
	DW PSTOR
	DW ZERO
	DW INN
	DW STORE
	DW BLK
	DW AT
	DW BSCR
	DW ONE
	DW SUBB
	DW ANDD
	DW ZEQU
	DW ZBRAN
	DW NULL2-$
	DW QEXEC
	DW FROMR
	DW DROP
NULL2	DW BRAN
	DW NULL3-$
NULL1	DW FROMR
	DW DROP
NULL3	DW SEMIS
;
	DB 84H
	DB 'FIL'
	DB 'L'+80H
	DW NULL-4
FILL	DW $+2
	MOV L,C
	MOV H,B
	POP D
	POP B
	XTHL
	XCHG
FILL1	MOV A,B
	ORA C
	JZ FILL2
	MOV A,L
	STAX D
	INX D
	DCX B
	JMP FILL1
FILL2	POP B
	JMP NEXT
;
	DB 85H
	DB 'ERAS'
	DB 'E'+80H
	DW FILL-7
ERASEE	DW DOCOL
	DW ZERO
	DW FILL
	DW SEMIS
;
	DB 86H
	DB 'BLANK'
	DB 'S'+80H
	DW ERASEE-8
BLANK	DW DOCOL
	DW BL
	DW FILL
	DW SEMIS
;
	DB 84H
	DB 'HOL'
	DB 'D'+80H
	DW BLANK-9
HOLD	DW DOCOL
	DW LIT
	DW -1
	DW HLD
	DW PSTOR
	DW HLD
	DW AT
	DW CSTOR
	DW SEMIS
;
	DB 83H
	DB 'PA'
	DB 'D'+80H
	DW HOLD-7
PAD	DW DOCOL
	DW HERE
	DW LIT
	DW 44H
	DW PLUS
	DW SEMIS
;
	DB 84H
	DB 'WOR'
	DB 'D'+80H
	DW PAD-6
WORD	DW DOCOL
	DW BLK
	DW AT
	DW ZBRAN
	DW WORD1-$
	DW BLK
	DW AT
	DW BLOCK
	DW BRAN
	DW WORD2-$
WORD1	DW TIB
	DW AT
WORD2	DW INN
	DW AT
	DW PLUS
	DW SWAP
	DW ENCL
	DW HERE
	DW LIT
	DW 22H
	DW BLANK
	DW INN
	DW PSTOR
	DW OVER
	DW SUBB
	DW TOR
	DW RR
	DW HERE
	DW CSTOR
	DW PLUS
	DW HERE
	DW ONEP
	DW FROMR
	DW CMOVE
	DW SEMIS
;
	DB 88H
	DB '(NUMBER'
	DB ')'+80H
	DW WORD-7
PNUMB	DW DOCOL
PNUM1	DW ONEP
	DW DUP
	DW TOR
	DW CAT
	DW BASE
	DW AT
	DW DIGIT
	DW ZBRAN
	DW PNUM2-$
	DW SWAP
	DW BASE
	DW AT
	DW USTAR
	DW DROP
	DW ROT
	DW BASE
	DW AT
	DW USTAR
	DW DPLUS
	DW DPL
	DW AT
	DW ONEP
	DW ZBRAN
	DW PNUM3-$
	DW ONE
	DW DPL
	DW PSTOR
PNUM3	DW FROMR
	DW BRAN
	DW PNUM1-$
PNUM2	DW FROMR
	DW SEMIS
;
	DB 86H
	DB 'NUMBE'
	DB 'R'+80H
	DW PNUMB-0BH
NUMB	DW DOCOL
	DW ZERO
	DW ZERO
	DW ROT
	DW DUP
	DW ONEP
	DW CAT
	DW LIT
	DW 2DH
	DW EQUAL
	DW DUP
	DW TOR
	DW PLUS
	DW LIT
	DW -1
NUMB1	DW DPL
	DW STORE
	DW PNUMB
	DW DUP
	DW CAT
	DW BL
	DW SUBB
	DW ZBRAN
	DW NUMB2-$
	DW DUP
	DW CAT
	DW LIT
	DW 2EH
	DW SUBB
	DW ZERO
	DW QERR
	DW ZERO
	DW BRAN
	DW NUMB1-$
NUMB2	DW DROP
	DW FROMR
	DW ZBRAN
	DW NUMB3-$
	DW DMINU
NUMB3	DW SEMIS
;
	DB 85H
	DB '-FIN'
	DB 'D'+80H
	DW NUMB-9
DFIND	DW DOCOL
	DW BL
	DW WORD
	DW HERE
	DW CONT
	DW AT
	DW AT
	DW PFIND
	DW DUP
	DW ZEQU 
	DW ZBRAN
	DW DFIN1-$
	DW DROP
	DW HERE
	DW LATES
	DW PFIND
DFIN1	DW SEMIS
;
	DB 87H
	DB '(ABORT'
	DB ')'+80H
	DW DFIND-8
PABOR	DW DOCOL
	DW ABORT
	DW SEMIS
;
	DB 85H
	DB 'ERRO'
	DB 'R'+80H
	DW PABOR-0AH
ERROR	DW DOCOL
	DW WARN
	DW AT
	DW ZLESS
	DW ZBRAN
	DW ERRO1-$
	DW PABOR
ERRO1	DW HERE
	DW COUNT
	DW TYPE
	DW PDOTQ
	DB 2
	DB '? '
	DW MESS
	DW SPSTO
;	CHANGE FROM FIG MODEL
;	DW INN,AT,BLK,AT
	DW BLK,AT
	DW DDUP
	DW ZBRAN,ERRO2-$
	DW INN,AT
	DW SWAP
ERRO2	DW QUIT
;
	DB 83H
	DB 'ID'
	DB '.'+80H
	DW ERROR-8
IDDOT	DW DOCOL
	DW PAD
	DW LIT
	DW 20H
	DW LIT
	DW 5FH
	DW FILL
	DW DUP
	DW PFA
	DW LFA
	DW OVER
	DW SUBB
	DW PAD
	DW SWAP
	DW CMOVE
	DW PAD
	DW COUNT
	DW LIT
	DW 1FH
	DW ANDD
	DW TYPE
	DW SPACE
	DW SEMIS
;
	DB 86H
	DB 'CREAT'
	DB 'E'+80H
	DW IDDOT-6
CREAT	DW DOCOL
	DW DFIND
	DW ZBRAN
	DW CREA1-$
	DW DROP
	DW NFA
	DW IDDOT
	DW LIT
	DW 4
	DW MESS
	DW SPACE
CREA1	DW HERE
	DW DUP
	DW CAT
	DW WIDTH
	DW AT
	DW MIN
	DW ONEP
	DW ALLOT
	DW DUP
	DW LIT
	DW 0A0H
	DW TOGGL
	DW HERE
	DW ONE
	DW SUBB
	DW LIT
	DW 80H
	DW TOGGL
	DW LATES
	DW COMMA
	DW CURR
	DW AT
	DW STORE
	DW HERE
	DW TWOP
	DW COMMA
	DW SEMIS
;
	DB 0C9H
	DB '[COMPILE'
	DB ']'+80H
	DW CREAT-9
BCOMP	DW DOCOL
	DW DFIND
	DW ZEQU
	DW ZERO
	DW QERR
	DW DROP
	DW CFA
	DW COMMA
	DW SEMIS
;
	DB 0C7H
	DB 'LITERA'
	DB 'L'+80H
	DW BCOMP-0CH
LITER	DW DOCOL
	DW STATE
	DW AT
	DW ZBRAN
	DW LITE1-$
	DW COMP
	DW LIT
	DW COMMA
LITE1	DW SEMIS
;
	DB 0C8H
	DB 'DLITERA'
	DB 'L'+80H
	DW LITER-0AH
DLITE	DW DOCOL
	DW STATE
	DW AT
	DW ZBRAN
	DW DLIT1-$
	DW SWAP
	DW LITER
	DW LITER
DLIT1	DW SEMIS
;
	DB 86H
	DB '?STAC'
	DB 'K'+80H
	DW DLITE-0BH
QSTAC	DW DOCOL
	DW SPAT
	DW SZERO
	DW AT
	DW SWAP
	DW ULESS
	DW ONE
	DW QERR
	DW SPAT
	DW HERE
	DW LIT
	DW 80H
	DW PLUS
	DW ULESS
	DW LIT
	DW 7
	DW QERR
	DW SEMIS
;
	DB 89H
	DB 'INTERPRE'
	DB 'T'+80H
	DW QSTAC-9
INTER	DW DOCOL
INTE1	DW DFIND
	DW ZBRAN
	DW INTE2-$
	DW STATE
	DW AT
	DW LESS
	DW ZBRAN
	DW INTE3-$
	DW CFA
	DW COMMA
	DW BRAN
	DW INTE4-$
INTE3	DW CFA
	DW EXEC
INTE4	DW QSTAC
	DW BRAN
	DW INTE5-$
INTE2	DW HERE
	DW NUMB
	DW DPL
	DW AT
	DW ONEP
	DW ZBRAN
	DW INTE6-$
	DW DLITE
	DW BRAN
	DW INTE7-$
INTE6	DW DROP
	DW LITER
INTE7	DW QSTAC
INTE5	DW BRAN
	DW INTE1-$
;
	DB 89H
	DB 'IMMEDIAT'
	DB 'E'+80H
	DW INTER-0CH
IMMED	DW DOCOL
	DW LATES
	DW LIT
	DW 40H
	DW TOGGL
	DW SEMIS
;
	DB 8AH
	DB 'VOCABULAR'
	DB 'Y'+80H
	DW IMMED-0CH
VOCAB	DW DOCOL
	DW BUILD
	DW LIT
	DW 0A081H
	DW COMMA
	DW CURR
	DW AT
	DW CFA
	DW COMMA
	DW HERE
	DW VOCL
	DW AT
	DW COMMA
	DW VOCL
	DW STORE
	DW DOES
DOVOC	DW TWOP
	DW CONT
	DW STORE
	DW SEMIS
;
	DB 0C5H
	DB 'FORT'
	DB 'H'+80H
	DW VOCAB-0DH
FORTH	DW DODOE
	DW DOVOC
	DW 0A081H
	DW TASK-7
;
	DW 0
;
	DB 8BH
	DB 'DEFINITION'
	DB 'S'+80H
	DW FORTH-8
DEFIN	DW DOCOL
	DW CONT
	DW AT
	DW CURR
	DW STORE
	DW SEMIS
;
	DB 0C1H
	DB '('+80H
	DW DEFIN-0EH
PAREN	DW DOCOL
	DW LIT
	DW 29H
	DW WORD
	DW SEMIS
;
	DB 84H
	DB 'QUI'
	DB 'T'+80H
	DW PAREN-4
QUIT	DW DOCOL
	DW ZERO
	DW BLK
	DW STORE
	DW LBRAC
QUIT1	DW RPSTO
	DW CR
	DW QUERY
	DW INTER
	DW STATE
	DW AT
	DW ZEQU
	DW ZBRAN
	DW QUIT2-$
	DW PDOTQ
	DB 2
	DB 'OK'
QUIT2	DW BRAN
	DW QUIT1-$
;
	DB 85H
	DB 'ABOR'
	DB 'T'+80H
	DW QUIT-7
ABORT	DW DOCOL
	DW SPSTO
	DW DEC
	DW QSTAC
	DW CR
	DW DOTCPU
	DW PDOTQ
	DB 0DH
	DB 'FIG-FORTH '
	DB FIGREL+30H,ADOT,FIGREV+30H
	DW FORTH
	DW DEFIN
	DW QUIT
;
;
WRM	LXI B,WRM1
	JMP NEXT
WRM1	DW WARM
;
	DB 84H
	DB 'WAR'
	DB 'M'+80H
	DW ABORT-8
WARM	DW DOCOL
	DW MTBUF
	DW ABORT
;
CLD	LXI B,CLD1
	LHLD ORIG+12H
	SPHL
	JMP NEXT
CLD1	DW COLD
;
	DB 84H
	DB 'COL'
	DB 'D'+80H
	DW WARM-7
COLD	DW DOCOL
	DW MTBUF
	DW ZERO,DENSTY
	DW STORE
	DW LIT,BUF1
	DW USE,STORE
	DW LIT,BUF1
	DW PREV,STORE
	DW DRZER
	DW LIT,0
	DW LIT,EPRINT
	DW STORE
;
	DW LIT
	DW ORIG+12H
	DW LIT
	DW UP
	DW AT
	DW LIT
	DW 6
	DW PLUS
	DW LIT
	DW 10H
	DW CMOVE
	DW LIT
	DW ORIG+0CH
	DW AT
	DW LIT
	DW FORTH+6
	DW STORE
	DW ABORT
;
	DB 84H
	DB 'S->'
	DB 'D'+80H
	DW COLD-7
STOD	DW $+2
	POP D
	LXI H,0
	MOV A,D
	ANI 80H
	JZ STOD1
	DCX H
STOD1	JMP DPUSH
;
	DB 82H
	DB '+'
	DB '-'+80H
	DW STOD-7
PM	DW DOCOL
	DW ZLESS
	DW ZBRAN
	DW PM1-$
	DW MINUS
PM1	DW SEMIS
;
	DB 83H
	DB 'D+'
	DB '-'+80H
	DW PM-5
DPM	DW DOCOL
	DW ZLESS
	DW ZBRAN
	DW DPM1-$
	DW DMINU
DPM1	DW SEMIS
;
	DB 83H
	DB 'AB'
	DB 'S'+80H
	DW DPM-6
ABS	DW DOCOL
	DW DUP
	DW PM
	DW SEMIS
;
	DB 84H
	DB 'DAB'
	DB 'S'+80H
	DW ABS-6
DABS	DW DOCOL
	DW DUP
	DW DPM
	DW SEMIS
;
	DB 83H
	DB 'MI'
	DB 'N'+80H
	DW DABS-7
MIN	DW DOCOL,TDUP
	DW GREAT
	DW ZBRAN
	DW MIN1-$
	DW SWAP
MIN1	DW DROP
	DW SEMIS
;
	DB 83H
	DB 'MA'
	DB 'X'+80H
	DW MIN-6
MAX	DW DOCOL,TDUP
	DW LESS
	DW ZBRAN
	DW MAX1-$
	DW SWAP
MAX1	DW DROP
	DW SEMIS
;
	DB 82H
	DB 'M'
	DB '*'+80H
	DW MAX-6
MSTAR	DW DOCOL,TDUP
	DW XORR
	DW TOR
	DW ABS
	DW SWAP
	DW ABS
	DW USTAR
	DW FROMR
	DW DPM
	DW SEMIS
;
	DB 82H
	DB 'M'
	DB '/'+80H
	DW MSTAR-5
MSLAS	DW DOCOL
	DW OVER
	DW TOR
	DW TOR
	DW DABS
	DW RR
	DW ABS
	DW USLAS
	DW FROMR
	DW RR
	DW XORR
	DW PM
	DW SWAP
	DW FROMR
	DW PM
	DW SWAP
	DW SEMIS
;
	DB 81H
	DB '*'+80H
	DW MSLAS-5
STAR	DW DOCOL
	DW MSTAR
	DW DROP
	DW SEMIS
;
	DB 84H
	DB '/MO'
	DB 'D'+80H
	DW STAR-4
SLMOD	DW DOCOL
	DW TOR
	DW STOD
	DW FROMR
	DW MSLAS
	DW SEMIS
;
	DB 81H
	DB '/'+80H
	DW SLMOD-7
SLASH	DW DOCOL
	DW SLMOD
	DW SWAP
	DW DROP
	DW SEMIS
;
	DB 83H
	DB 'MO'
	DB 'D'+80H
	DW SLASH-4
MODD	DW DOCOL
	DW SLMOD
	DW DROP
	DW SEMIS
;
	DB 85H
	DB '*/MO'
	DB 'D'+80H
	DW MODD-6
SSMOD	DW DOCOL
	DW TOR
	DW MSTAR
	DW FROMR
	DW MSLAS
	DW SEMIS
;
	DB 82H
	DB '*'
	DB '/'+80H
	DW SSMOD-8
SSLA	DW DOCOL
	DW SSMOD
	DW SWAP
	DW DROP
	DW SEMIS
;
	DB 85H
	DB 'M/MO'
	DB 'D'+80H
	DW SSLA-5
MSMOD	DW DOCOL
	DW TOR
	DW ZERO
	DW RR
	DW USLAS
	DW FROMR
	DW SWAP
	DW TOR
	DW USLAS
	DW FROMR
	DW SEMIS
;
;	BLOCK MOVED DOWN 2 PAGES
;
;
	DB 86H
	DB '(LINE'
	DB ')'+80H
	DW MSMOD-8
PLINE	DW DOCOL
	DW TOR
	DW LIT
	DW 40H
	DW BBUF
	DW SSMOD 
	DW FROMR
	DW BSCR
	DW STAR
	DW PLUS
	DW BLOCK
	DW PLUS
	DW LIT
	DW 40H
	DW SEMIS
;
	DB 85H
	DB '.LIN'
	DB 'E'+80H
	DW PLINE-9
DLINE	DW DOCOL
	DW PLINE
	DW DTRAI
	DW TYPE
	DW SEMIS
;
	DB 87H
	DB 'MESSAG'
	DB 'E'+80H
	DW DLINE-8
MESS	DW DOCOL
	DW WARN
	DW AT
	DW ZBRAN
	DW MESS1-$
	DW DDUP
	DW ZBRAN
	DW MESS2-$
	DW LIT
	DW 4
	DW OFSET
	DW AT
	DW BSCR
	DW SLASH
	DW SUBB
	DW DLINE
	DW SPACE
MESS2	DW BRAN
	DW MESS3-$
MESS1	DW PDOTQ
	DB 6
	DB 'MSG # '
	DW DOT
MESS3	DW SEMIS
;
;	8080 PORT FETCH AND STORE
;	( SELF MODIFYING CODE, NOT REENTRANT)
;
	DB 82H
	DB 'P'
	DB '@'+80H
	DW MESS-0AH
PTAT:	DW $+2
	POP D
	LXI H,$+5
	MOV M,E
	IN 0
	MOV L,A
	MVI H,0
	JMP HPUSH
;
	DB 82H
	DB 'P'
	DB '!'+80H
	DW PTAT-5
PTSTO:	DW $+2
	POP D
	LXI H,$+7
	MOV M,E
	POP H
	MOV A,L
	OUT 0
	JMP NEXT
;
;	CP/M DISK INTERFACE
;
;	CP/M BIOS CALLS USED
;
;	NOTE EQU'S ARE 3 LOWER THAN DOCUMENTED OFFSETS
;	BECAUSE BASE ADDR IS BIOS+3
;
RITSEC	EQU 39
RDSEC	EQU 36
SETDMA	EQU 33
SETSEC	EQU 30
SETTRK	EQU 27
SETDSK	EQU 24
;
;	DOUBLE DENSITY 8" CAPACITIES
SPT2	EQU 52
TRKS2	EQU 77
SPDRV2	EQU SPT2*TRKS2
;	SINGLE DENSITY 8" CAPACITIES
SPT1	EQU 20
TRKS1	EQU 40
SPDRV1	EQU SPT1*TRKS1
;
BPS	EQU 128
MXDRV	EQU 2
;
;	FORTH VARIABLES AND CONSTANTS USED IN DISK INTERFACE
;
	DB 85H
	DB 'DRIV'
	DB 'E'+80H
	DW PTSTO-5
DRIVE	DW DOVAR,0
;
	DB 83H
	DB 'SE'
	DB 'C'+80H
	DW DRIVE-8
SEC:	DW DOVAR
	DW 0
;
	DB 85H
	DB 'TRAC'
	DB 'K'+80H
	DW SEC-6
TRACK:	DW DOVAR,0
;
	DB 83H
	DB 'US'
	DB 'E'+80H
	DW TRACK-8
USE:	DW DOVAR
	DW BUF1
;
	DB 84H
	DB 'PRE'
	DB 'V'+80H
	DW USE-6
PREV	DW DOVAR
	DW BUF1
;
	DB 87H
	DB 'SEC/BL'
	DB 'K'+80H
	DW PREV-7
SPBLK	DW DOCON
	DW KBBUF/BPS
;
	DB 85H
	DB '#BUF'
	DB 'F'+80H
	DW SPBLK-10
NOBUF	DW DOCON,NBUF
;
	DB 87H
	DB 'DENSIT'
	DB 'Y'+80H
	DW NOBUF-8
DENSTY	DW DOVAR
	DW 0
;
	DB 8AH
	DB 'DISK-ERRO'
	DB 'R'+80H
	DW DENSTY-10
DSKERR	DW DOVAR,0
;
;	DISK INTERFACE HIGH LEVEL ROUTINES
;
	DB 84H
	DB '+BU'
	DB 'F'+80H
	DW DSKERR-13
PBUF	DW DOCOL
	DW LIT,CO
	DW PLUS,DUP
	DW LIMIT,EQUAL
	DW ZBRAN,PBUF1-$
	DW DROP,FIRST
PBUF1:	DW DUP,PREV
	DW AT,SUBB
	DW SEMIS
;
	DB 86H
	DB 'UPDAT'
	DB 'E'+80H
	DW PBUF-7
UPDAT	DW DOCOL,PREV
	DW AT,AT
	DW LIT,8000H
	DW ORR
	DW PREV,AT
	DW STORE,SEMIS
;
	DB 8DH
	DB 'EMPTY-BUFFER'
	DB 'S'+80H
	DW UPDAT-9
MTBUF	DW DOCOL,FIRST
	DW LIMIT,OVER
	DW SUBB,ERASEE
	DW SEMIS
;
	DB 83H
	DB 'DR'
	DB '0'+80H
	DW MTBUF-16
DRZER	DW DOCOL,ZERO
	DW OFSET,STORE
	DW SEMIS
;
	DB 83H
	DB 'DR'
	DB '1'+80H
	DW DRZER-6
DRONE	DW DOCOL
	DW DENSTY,AT
	DW ZBRAN,DRON1-$
	DW LIT,SPDRV2
	DW BRAN,DRON2-$
DRON1	DW LIT,SPDRV1
DRON2	DW OFSET,STORE
	DW SEMIS
;
	DB 86H
	DB 'BUFFE'
	DB 'R'+80H
	DW DRONE-6
BUFFE:	DW DOCOL,USE
	DW AT,DUP
	DW TOR
BUFF1	DW PBUF
	DW ZBRAN,BUFF1-$
	DW USE,STORE
	DW RR,AT
	DW ZLESS
	DW ZBRAN,BUFF2-$
	DW RR,TWOP
	DW RR,AT
	DW LIT,7FFFH
	DW ANDD,ZERO
	DW RSLW
BUFF2	DW RR,STORE
	DW RR,PREV
	DW STORE,FROMR
	DW TWOP,SEMIS
;
	DB 85H
	DB 'BLOC'
	DB 'K'+80H
	DW BUFFE-9
BLOCK	DW DOCOL,OFSET
	DW AT,PLUS
	DW TOR,PREV
	DW AT,DUP
	DW AT,RR
	DW SUBB
	DW DUP,PLUS
	DW ZBRAN,BLOC1-$
BLOC2	DW PBUF,ZEQU
	DW ZBRAN,BLOC3-$
	DW DROP,RR
	DW BUFFE,DUP
	DW RR,ONE
	DW RSLW
	DW TWO,SUBB
BLOC3	DW DUP,AT
	DW RR,SUBB
	DW DUP,PLUS
	DW ZEQU
	DW ZBRAN,BLOC2-$
	DW DUP,PREV
	DW STORE
BLOC1	DW FROMR,DROP
	DW TWOP,SEMIS
;
;
;	CP/M INTERFACE ROUTINES
;
;
IOS	LHLD HBASE+1
	DAD D
	PCHL
;
;
	DB 86H
;
	DB 'SET-I'
	DB 'O'+80H
	DW BLOCK-8
SETIO:	DW $+2
	PUSH B
	LHLD USE+2
	MOV B,H
	MOV C,L
	LXI D,SETDMA
	CALL IOS
;
	LHLD SEC+2
	MOV C,L
	LXI D,SETSEC
	CALL IOS
;
	LHLD TRACK+2
	MOV B,H
	MOV C,L
	LXI D,SETTRK
	CALL IOS
;
	POP B
	JMP NEXT
;
	DB 89H
	DB 'SET-DRIV'
	DB 'E'+80H
	DW SETIO-9
SETDRV:	DW $+2
	PUSH B
	LDA DRIVE+2
	MOV C,A
	LXI D,SETDSK
	CALL IOS
	POP B
	JMP NEXT
;
;	T&SCALC (CALCULATES DRIVE, TRACK, AND SECTOR)
;
;
	DB 87H
	DB 'T&SCAL'
	DB 'C'+80H
	DW SETDRV-12
TSCALC:	DW DOCOL,DENSTY
	DW AT
	DW ZBRAN,TSCALS-$
	DW LIT,SPDRV2
	DW SLMOD
	DW LIT,MXDRV
	DW MIN
	DW DUP,DRIVE
	DW AT,EQUAL
	DW ZBRAN,TSCAL1-$
	DW DROP
	DW BRAN,TSCAL2-$
TSCAL1	DW DRIVE,STORE
	DW SETDRV
TSCAL2	DW LIT,SPT2
	DW SLMOD,TRACK
	DW STORE,ONEP
	DW SEC,STORE
	DW SEMIS
;	SINGLE DENSITY
TSCALS	DW LIT,SPDRV1
	DW SLMOD
	DW LIT,MXDRV
	DW MIN
	DW DUP,DRIVE
	DW AT,EQUAL
	DW ZBRAN,TSCAL3-$
	DW DROP
	DW BRAN,TSCAL4-$
TSCAL3	DW DRIVE,STORE
	DW SETDRV
TSCAL4	DW LIT,SPT1
	DW SLMOD,TRACK
	DW STORE,ONEP
	DW SEC,STORE
	DW SEMIS
;
;	SEC-READ
;
	DB 88H
	DB 'SEC-REA'
	DB 'D'+80H
	DW TSCALC-10
SECRD	DW $+2
	PUSH B
	LXI D,RDSEC
	CALL IOS
	STA DSKERR+2
	POP B
	JMP NEXT
;
;	SEC-WRITE
;
	DB 89H
	DB 'SEC-WRIT'
	DB 'E'+80H
	DW SECRD-11
SECWT	DW $+2
	PUSH B
	LXI D,RITSEC
	CALL IOS
	STA DSKERR+2
	POP B
	JMP NEXT
;
	DB 83H
	DB 'R/'
	DB 'W'+80H
	DW SECWT-12
RSLW	DW DOCOL
	DW USE,AT
	DW TOR
	DW SWAP,SPBLK
	DW STAR,ROT
	DW USE,STORE
	DW SPBLK,ZERO
	DW XDO
RSLW1	DW OVER,OVER
	DW TSCALC,SETIO
	DW ZBRAN,RSLW2-$
	DW SECRD
	DW BRAN,RSLW3-$
RSLW2	DW SECWT
RSLW3	DW ONEP
	DW LIT,80H
	DW USE,PSTOR
	DW XLOOP,RSLW1-$
	DW DROP,DROP
	DW FROMR,USE
	DW STORE,SEMIS
;
	DB 85H
	DB 'FLUS'
	DB 'H'+80H
	DW RSLW-6
FLUSH	DW DOCOL
	DW NOBUF,ONEP
	DW ZERO,XDO
FLUS1	DW ZERO,BUFFE
	DW DROP
	DW XLOOP,FLUS1-$
	DW SEMIS
;
	DB 84H
	DB 'LOA'
	DB 'D'+80H
	DW FLUSH-8
LOAD	DW DOCOL,BLK
	DW AT,TOR
	DW INN,AT
	DW TOR,ZERO
	DW INN,STORE
	DW BSCR,STAR
	DW BLK,STORE
	DW INTER
	DW FROMR,INN
	DW STORE
	DW FROMR,BLK
	DW STORE
	DW SEMIS
;
	DB 0C3H
	DB '--'
	DB '>'+80H
	DW LOAD-7
ARROW	DW DOCOL
	DW QLOAD
	DW ZERO
	DW INN
	DW STORE
	DW BSCR
	DW BLK
	DW AT
	DW OVER
	DW MODD
	DW SUBB
	DW BLK
	DW PSTOR
	DW SEMIS
;
;
;	CP/M CONSOLE AND PRINTER INTERFACE
;
;
KCSTAT	EQU 3
KCIN	EQU 6
KCOUT	EQU 9
KPOUT	EQU 0CH
;
EPRINT	DW 0
;
;
CSTAT	PUSH B
	LXI D,KCSTAT
	CALL IOS
	POP B
	RET
;
;
CIN	PUSH B
	LXI D,KCIN
	CALL IOS
	POP B
	RET
;
COUT	PUSH H
	LXI D,KCOUT
	CALL IOS
	POP H
	RET
;
POUT	LXI D,KPOUT
	CALL IOS
	RET
;
CPOUT	CALL COUT
	XCHG
	LXI H,EPRINT
	MOV A,M
	ORA A
	JZ CPOU1
	MOV C,E
	CALL POUT
CPOU1	RET
;
;	FORTH TO CP/M SERIAL IO INTERFACE
;
PQTER	CALL CSTAT
	LXI H,0
	ORA A
	JZ PQTE1
	INR L
PQTE1	JMP HPUSH
;
PKEY	CALL CIN
	CPI DLE
	MOV E,A
	JNZ PKEY1
	LXI H,EPRINT
	MVI E,ABL
	MOV A,M
	XRI 1
	MOV M,A
PKEY1	MOV L,E
	MVI H,0
	JMP HPUSH
;
PEMIT	DW $+2
	POP H
	PUSH B
	MOV C,L
	CALL CPOUT
;
	POP B
	JMP NEXT
;
PCR	PUSH B
	MVI C,ACR
	MOV L,C
	CALL CPOUT
	MVI C,LF
	MOV L,C
	CALL CPOUT
	POP B
	JMP NEXT
;
	DB 0C1H
	DB 0A7H ;(')
	DW ARROW-6
TICK	DW DOCOL
	DW DFIND
	DW ZEQU
	DW ZERO
	DW QERR
	DW DROP
	DW LITER
	DW SEMIS
;
	DB 86H
	DB 'FORGE'
	DB 'T'+80H
	DW TICK-4
FORG	DW DOCOL
	DW CURR
	DW AT
	DW CONT
	DW AT
	DW SUBB
	DW LIT
	DW 18H
	DW QERR
	DW TICK
	DW DUP
	DW FENCE
	DW AT
	DW LESS
	DW LIT
	DW 15H
	DW QERR
	DW DUP
	DW NFA
	DW DP
	DW STORE
	DW LFA
	DW AT
	DW CONT
	DW AT
	DW STORE
	DW SEMIS
;
	DB 84H
	DB 'BAC'
	DB 'K'+80H
	DW FORG-9
BACK	DW DOCOL
	DW HERE
	DW SUBB
	DW COMMA
	DW SEMIS
;
	DB 0C5H
	DB 'BEGI'
	DB 'N'+80H
	DW BACK-7
BEGIN	DW DOCOL
	DW QCOMP
	DW HERE
	DW ONE
	DW SEMIS
;
	DB 0C5H
	DB 'ENDI'
	DB 'F'+80H
	DW BEGIN-8
ENDIFF	DW DOCOL
	DW QCOMP
	DW TWO
	DW QPAIR
	DW HERE
	DW OVER
	DW SUBB
	DW SWAP
	DW STORE
	DW SEMIS
;
	DB 0C4H
	DB 'THE'
	DB 'N'+80H
	DW ENDIFF-8
THEN	DW DOCOL
	DW ENDIFF
	DW SEMIS
;
	DB 0C2H
	DB 'D'
	DB 'O'+80H
	DW THEN-7
DO	DW DOCOL
	DW COMP
	DW XDO
	DW HERE
	DW THREE
	DW SEMIS
;
	DB 0C4H
	DB 'LOO'
	DB 'P'+80H
	DW DO-5
LOOP	DW DOCOL
	DW THREE
	DW QPAIR
	DW COMP
	DW XLOOP
	DW BACK
	DW SEMIS
;
	DB 0C5H
	DB '+LOO'
	DB 'P'+80H
	DW LOOP-7
PLOOP	DW DOCOL
	DW THREE
	DW QPAIR
	DW COMP
	DW XPLOO
	DW BACK
	DW SEMIS
;
	DB 0C5H
	DB 'UNTI'
	DB 'L'+80H
	DW PLOOP-8
UNTIL	DW DOCOL
	DW ONE
	DW QPAIR
	DW COMP 
	DW ZBRAN
	DW BACK
	DW SEMIS
;
	DB 0C3H
	DB 'EN'
	DB 'D'+80H
	DW UNTIL-8
ENDD	DW DOCOL
	DW UNTIL
	DW SEMIS
;
	DB 0C5H
	DB 'AGAI'
	DB 'N'+80H
	DW ENDD-6
AGAIN	DW DOCOL
	DW ONE
	DW QPAIR
	DW COMP
	DW BRAN
	DW BACK
	DW SEMIS
;
	DB 0C6H
	DB 'REPEA'
	DB 'T'+80H
	DW AGAIN-8
REPEA	DW DOCOL
	DW TOR
	DW TOR
	DW AGAIN
	DW FROMR
	DW FROMR
	DW TWO
	DW SUBB
	DW ENDIFF
	DW SEMIS
	DB 0C2H
	DB 'I'
	DB 'F'+80H
	DW REPEA-9
IFF	DW DOCOL
	DW COMP
	DW ZBRAN
	DW HERE
	DW ZERO
	DW COMMA
	DW TWO
	DW SEMIS
;
	DB 0C4H
	DB 'ELS'
	DB 'E'+80H
	DW IFF-5
ELSEE	DW DOCOL
	DW TWO
	DW QPAIR
	DW COMP
	DW BRAN
	DW HERE
	DW ZERO
	DW COMMA
	DW SWAP
	DW TWO
	DW ENDIFF
	DW TWO
	DW SEMIS
;
	DB 0C5H
	DB 'WHIL'
	DB 'E'+80H
	DW ELSEE-7
WHILE	DW DOCOL
	DW IFF
	DW TWOP
	DW SEMIS
;
	DB 86H
	DB 'SPACE'
	DB 'S'+80H
	DW WHILE-8
SPACS	DW DOCOL
	DW ZERO
	DW MAX
	DW DDUP
	DW ZBRAN
	DW SPAX1-$
	DW ZERO
	DW XDO
SPAX2	DW SPACE
	DW XLOOP
	DW SPAX2-$
SPAX1	DW SEMIS
;
	DB 82H
	DB '<'
	DB '#'+80H
	DW SPACS-9
BDIGS	DW DOCOL
	DW PAD
	DW HLD
	DW STORE
	DW SEMIS
;
	DB 82H
	DB '#'
	DB '>'+80H
	DW BDIGS-5
EDIGS	DW DOCOL
	DW DROP
	DW DROP
	DW HLD
	DW AT
	DW PAD
	DW OVER
	DW SUBB
	DW SEMIS
;
	DB 84H
	DB 'SIG'
	DB 'N'+80H
	DW EDIGS-5
SIGN	DW DOCOL
	DW ROT
	DW ZLESS
	DW ZBRAN
	DW SIGN1-$
	DW LIT
	DW 2DH
	DW HOLD
SIGN1	DW SEMIS
;
	DB 81H
	DB '#'+80H
	DW SIGN-7
DIG	DW DOCOL
	DW BASE
	DW AT
	DW MSMOD
	DW ROT
	DW LIT
	DW 9
	DW OVER
	DW LESS
	DW ZBRAN
	DW DIG1-$
	DW LIT
	DW 7
	DW PLUS
DIG1	DW LIT
	DW 30H
	DW PLUS
	DW HOLD
	DW SEMIS
;
	DB 82H
	DB '#'
	DB 'S'+80H
	DW DIG-4
DIGS	DW DOCOL
DIGS1	DW DIG
	DW OVER
	DW OVER
	DW ORR
	DW ZEQU
	DW ZBRAN
	DW DIGS1-$
	DW SEMIS
;
	DB 83H
	DB 'D.'
	DB 'R'+80H
	DW DIGS-5
DDOTR	DW DOCOL
	DW TOR
	DW SWAP
	DW OVER
	DW DABS
	DW BDIGS
	DW DIGS
	DW SIGN
	DW EDIGS
	DW FROMR
	DW OVER
	DW SUBB
	DW SPACS
	DW TYPE
	DW SEMIS
;
	DB 82H
	DB '.'
	DB 'R'+80H
	DW DDOTR-6
DOTR	DW DOCOL
	DW TOR
	DW STOD
	DW FROMR
	DW DDOTR
	DW SEMIS
;
	DB 82H
	DB 'D'
	DB '.'+80H
	DW DOTR-5
DDOT	DW DOCOL
	DW ZERO
	DW DDOTR
	DW SPACE
	DW SEMIS
;
	DB 81H
	DB '.'+80H
	DW DDOT-5
DOT	DW DOCOL
	DW STOD
	DW DDOT
	DW SEMIS
;
	DB 81H
	DB '?'+80H
	DW DOT-4
QUES	DW DOCOL
	DW AT
	DW DOT
	DW SEMIS
;
	DB 82H
	DB 'U'
	DB '.'+80H
	DW QUES-4
UDOT	DW DOCOL
	DW ZERO
	DW DDOT
	DW SEMIS
;
	DB 85H
	DB 'VLIS'
	DB 'T'+80H
	DW UDOT-5
VLIST	DW DOCOL
	DW LIT
	DW 80H
	DW OUTT
	DW STORE
	DW CONT
	DW AT
	DW AT
VLIS1	DW OUTT
	DW AT
	DW CSLL
	DW GREAT
	DW ZBRAN
	DW VLIS2-$
	DW CR
	DW ZERO
	DW OUTT
	DW STORE
VLIS2	DW DUP
	DW IDDOT
	DW SPACE
	DW SPACE
	DW PFA
	DW LFA
	DW AT
	DW DUP
	DW ZEQU
	DW QTERM
	DW ORR
	DW ZBRAN
	DW VLIS1-$
	DW DROP
	DW SEMIS
;
;------EXIT	CP/M------
;
	DB 83H
	DB 'BY'
	DB 'E'+80H
	DW VLIST-8
BYE	DW $+2
	JMP HBASE+0
;
	DB 84H
	DB 'LIS'
	DB 'T'+80H
	DW BYE-6
LIST	DW DOCOL,DEC
	DW CR,DUP
	DW SCR,STORE
	DW PDOTQ
	DB 6,'SCR # '
	DW DOT
	DW LIT,10H
	DW ZERO,XDO
LIST1	DW CR,IDO
	DW LIT,3
	DW DOTR,SPACE
	DW IDO,SCR
	DW AT,DLINE
	DW QTERM
	DW ZBRAN,LIST2-$
	DW LEAVE
LIST2	DW XLOOP,LIST1-$
	DW CR,SEMIS
;
	DB 85H
	DB 'INDE'
	DB 'X'+80H
	DW LIST-7
INDEX	DW DOCOL
	DW LIT,FF
	DW EMIT,CR
	DW ONEP,SWAP
	DW XDO
INDE1	DW CR,IDO
	DW LIT,3
	DW DOTR,SPACE
	DW ZERO,IDO
	DW DLINE,QTERM
	DW ZBRAN,INDE2-$
	DW LEAVE
INDE2	DW XLOOP,INDE1-$
	DW SEMIS
;
	DB 85H
	DB 'TRIA'
	DB 'D'+80H
	DW INDEX-8
TRIAD	DW DOCOL
	DW LIT,FF
	DW EMIT
	DW LIT,3
	DW SLASH
	DW LIT,3
	DW STAR
	DW LIT,3
	DW OVER,PLUS
	DW SWAP,XDO
TRIA1	DW CR,IDO
	DW LIST
	DW QTERM
	DW ZBRAN,TRIA2-$
	DW LEAVE
TRIA2	DW XLOOP,TRIA1-$
	DW CR
	DW LIT,15
	DW MESS,CR
	DW SEMIS
;
	DB 84H
	DB '.CP'
	DB 'U'+80H
	DW TRIAD-8
DOTCPU	DW DOCOL
	DW BASE,AT
	DW LIT,36
	DW BASE,STORE
	DW LIT,22H
	DW PORIG,TAT
	DW DDOT
	DW BASE,STORE
	DW SEMIS
;
	DB 84H
	DB 'TAS'
	DB 'K'+80H
	DW DOTCPU-7
TASK	DW DOCOL
	DW SEMIS
;
INITDP:	DS EM-$
;
;
;	MEMORY MAP
;
MCOLD	EQU ORIG
MWARM	EQU ORIG+4
MA2	EQU ORIG+8
MUP	EQU UP
MRP	EQU RPP
;
MBIP	EQU BIP
MDPUSH	EQU DPUSH
MHPUSH	EQU HPUSH
MNEXT	EQU NEXT
;
MDP0	EQU DP0
MDIO	EQU DRIVE
MCIO	EQU EPRINT
MIDP	EQU INITDP
;
MIS0	EQU INITS0
;
MIR0	EQU INITR0
;
MFIRST	EQU BUF1
;
MEND	EQU EM-1
MLIMIT	EQU EM
;
	END


